---
title: Hyperdrive introduces support for MySQL and MySQL-compatible databases ·
  Changelog
description: You can now connect to MySQL databases from your Workers using
  Hyperdrive for optimal performance
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-04-08-hyperdrive-mysql-support/
  md: https://developers.cloudflare.com/changelog/2025-04-08-hyperdrive-mysql-support/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Hyperdrive introduces support for MySQL and MySQL-compatible databases

Apr 08, 2025

[Hyperdrive](https://developers.cloudflare.com/hyperdrive/)

Hyperdrive now supports connecting to MySQL and MySQL-compatible databases, including Amazon RDS and Aurora MySQL, Google Cloud SQL for MySQL, Azure Database for MySQL, PlanetScale and MariaDB.

Hyperdrive makes your regional, MySQL databases fast when connecting from Cloudflare Workers. It eliminates unnecessary network roundtrips during connection setup, pools database connections globally, and can cache query results to provide the fastest possible response times.

Best of all, you can connect using your existing drivers, ORMs, and query builders with Hyperdrive's secure credentials, no code changes required.

```ts
import { createConnection } from "mysql2/promise";


export interface Env {
  HYPERDRIVE: Hyperdrive;
}


export default {
  async fetch(request, env, ctx): Promise<Response> {
    const connection = await createConnection({
      host: env.HYPERDRIVE.host,
      user: env.HYPERDRIVE.user,
      password: env.HYPERDRIVE.password,
      database: env.HYPERDRIVE.database,
      port: env.HYPERDRIVE.port,
      disableEval: true, // Required for Workers compatibility
    });


    const [results, fields] = await connection.query("SHOW tables;");


    ctx.waitUntil(connection.end());


    return new Response(JSON.stringify({ results, fields }), {
      headers: {
        "Content-Type": "application/json",
        "Access-Control-Allow-Origin": "*",
      },
    });
  },
} satisfies ExportedHandler<Env>;
```

Learn more about [how Hyperdrive works](https://developers.cloudflare.com/hyperdrive/configuration/how-hyperdrive-works/) and [get started building Workers that connect to MySQL with Hyperdrive](https://developers.cloudflare.com/hyperdrive/get-started/).
