---
title: Application Granular Controls · Cloudflare One docs
description: With Application Granular Controls, you can create Gateway HTTP
  policies to control specific user actions within supported SaaS applications.
  This allows you to give users access to an application while restricting the
  actions that they can take within the application.
lastUpdated: 2025-10-28T13:40:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/granular-controls/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/granular-controls/index.md
---

With Application Granular Controls, you can create [Gateway HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/) to control specific user actions within supported SaaS applications. This allows you to give users access to an application while restricting the actions that they can take within the application.

## Prerequisites

To use Application Granular Controls, you must:

* Install a [Cloudflare certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/) or a [custom certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/custom-certificate/) on your users' devices.
* Turn on [TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/).
* Turn on the [Gateway proxy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/proxy/#turn-on-the-gateway-proxy).
* (Optional) If an application uses HTTP/3, turn on the [Gateway proxy for UDP traffic](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/http3/#enable-http3-inspection).
* (Optional) To turn on [AI prompt logging](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#log-generative-ai-prompt-content), create a [DLP payload encryption public key](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#set-a-dlp-payload-encryption-public-key).

## Create a policy with Application Granular Controls

To create a Gateway HTTP policy with Application Granular Controls:

* Dashboard

  1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Traffic policies** > **Firewall policies**. Select **HTTP**.

  2. Select **Add a policy**.

  3. Name the policy.

  4. Under **Traffic**, build a logical expression that defines the traffic you want to allow or block. Because granular controls are specific to each application, you must use the *Application* selector with the *is* operator.

  5. In **Value**, select your desired application.

  6. In **Controls**, choose one or more Application Controls or individual Operations. For example, you can create a policy to block file uploads to ChatGPT:

     | Selector | Operator | Value | Controls | Action |
     | - | - | - | - | - |
     | Application | is | *ChatGPT* | *Upload* | Block |

  7. Select **Create policy**.

* API

  Use the [Create a Zero Trust Gateway rule](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/rules/methods/create/) endpoint to create a policy. For example, you can create a policy to block file uploads to ChatGPT:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Block ChatGPT uploads",
      "description": "Block file uploads to ChatGPT while allowing other usage",
      "enabled": true,
      "action": "block",
      "filters": [
          "http"
      ],
      "traffic": "any(app.ids[*] == 1199) and any(app_control.controls[*] in {1653})",
      "identity": "",
      "device_posture": ""
    }'
  ```

For more information, refer to [HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/).

## Control definitions

Gateway defines Application Granular Controls at different levels of granularity, including Application Controls and Operations.

### Application Controls

Application Controls are pre-defined controls which represent user intent, such as uploads or downloads. Cloudflare defines and organizes sets of operations deemed related to specific intents in an application. Application Controls represent the most commonly used controls.

### Operations

Operations are the individual API-level actions that an application uses. Defining controls at operation level allows for more fine-grained policies to support use cases such as blocking only certain types of downloads. You can also define controls where there is not an existing application control that covers the required intent, such as blocking comments. However, because each SaaS application uses a unique set of operations with its own scope and behaviors, the use of operation level controls often requires analysis for each desired use case. You can also use operation-level controls in cases where you need variations to the Cloudflare-defined application controls, such as including or excluding certain operations.

Cloudflare provides Operations based on the [available APIs for an application](#application-apis). For more information on how Operations map to [Application Controls](#application-controls), refer to [Compatible applications](#compatible-applications).

#### Operation Groups

Operation Groups are groupings of operations defined by the application vendor. Operation Groups are typically based on a categorization of the different functional areas of the application, such as signature requests, or the entities that the application defines, such as files or folders. These definitions vary by application. Gateway groups operations into these operation groups to match the operations with the corresponding vendor API documentation.

### DLP payloads

You can use Application Granular Controls with [Data Loss Prevention (DLP)](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/) for operations that contain scannable content. This includes operations that contain the content of uploaded or downloaded files or AI prompts. For example, when a user performs a file upload, a sequence of API operations may result, such as setting up the file metadata, uploading the file content, and finalizing the upload. When applying DLP to your Zero Trust traffic, it can be helpful to specifically target an operation that contains file content.

## Application APIs

SaaS applications typically provide multiple APIs to interact with. For each application, Application Granular Controls may support the following API types:

* Web Application API: These APIs are consumed by the web application that users interact with through their browser.
* Platform API: These APIs are exposed to users to allow for programmatic interaction with the SaaS application. These are typically used by automations, scripts, or other applications.

[Application Controls](#application-controls) include Operations of both API types. If both API types are available when creating HTTP policies using [Operations](#operations), you should select the Operations that align to the API being used, or include both for wider coverage.

## Compatible applications

Application Granular Controls supports the following applications:

AI

* ChatGPT
* Google Gemini
* Perplexity
* Claude

File sharing

* Box
* Dropbox
* Google Drive
* ShareFile
* Hightail
* Smash
* WeTransfer
