---
title: Set-up 2FA · Cloudflare Learning Paths
description: Two-factor authentication (2FA) allows user account owners to add
  an additional layer of login security to Cloudflare accounts. This additional
  authentication step requires you to provide both something you know, such as a
  Cloudflare password, and something you have, such as an authentication code
  from a mobile device.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/application-security/account-security/set-up-2fa/
  md: https://developers.cloudflare.com/learning-paths/application-security/account-security/set-up-2fa/index.md
---

Two-factor authentication (2FA) allows user account owners to add an additional layer of login security to Cloudflare accounts. This additional authentication step requires you to provide both something you know, such as a Cloudflare password, and something you have, such as an authentication code from a mobile device.

Note

Cloudflare user accounts configured to use single sign-on (SSO) cannot configure 2FA.

Cloudflare offers the option to use either a phishing-resistant security key, like a YubiKey, or a Time-Based One-Time password (TOTP) mobile app for authentication, like Google Authenticator, or both. If you add both of these authentication methods to your account, you are initially prompted to log in with the security key, but can opt-out and use TOTP instead.

To ensure that you can securely access your account even without your mobile device or security keys, Cloudflare also provides backup codes for download.

Tip

After downloading your backup codes, we recommend saving them in a secure location.

As the user account owner, you are automatically assigned the [Super Administrator](https://developers.cloudflare.com/fundamentals/manage-members/) role. Once 2FA is enabled, all Cloudflare account members are required to configure 2FA on their mobile devices.

***

## Enable 2FA

We recommend that all Cloudflare user account holders enable two-factor authentication (2FA) to keep your accounts secure. 

2FA can only be enabled successfully on an account with a [verified email address](https://developers.cloudflare.com/fundamentals/user-profiles/verify-email-address/). If you do not verify your email address first, you may lock yourself out of your account.

Warning

Super Administrators can turn on **2FA Enforcement** to require all members to enable 2FA. If you are not a Super Administrator, you will be forced to turn on 2FA prior to accepting the invitation to join a Cloudflare account as a member.

To enable two-factor authentication for your Cloudflare login:

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login).
2. Under the **My Profile** dropdown, select **My Profile**.
3. Select **Authentication**. 
4. Select **Manage** in the Two-Factor Authentication card.
5. Configure either a [TOTP mobile app](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/#configure-totp-mobile-application-authentication) or a [security key to enable 2FA on your account](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/#configure-security-key-authentication-for-two-factor-cloudflare-login).

## Additional configurations

Cloudflare also supports 2FA with device built-in authenticators (Apple Touch ID, Android fingerprint, or Windows Hello), Yubikeys and TOTP mobile applications.
